%{
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include "a.h"
#include "a.tab.h"
#include "Parser.h"

#define C THIS -> m_the_str[THIS -> m_the_ptr]
#define C_INCR THIS -> m_the_str[THIS -> m_the_ptr++]

#define YY_INPUT(buf,result,max_size) { \
	if ( THIS -> m_the_str) \
		*buf = C_INCR; \
	result = ( THIS -> m_the_str && *buf) ? 1 : YY_NULL; \
}

#define YY_DECL int yylex(void *yylval,void *parser)
#define YYLVAL ((YYSTYPE *)yylval)

%}

DIGIT	[0-9]
ID	[A-Z][A-Z0-9]*
STRING	"\""[^\"]*"\""

%%

{DIGIT}+	{
			YYLVAL -> d = atof(yytext);
			return NUM;
		}

{DIGIT}*"."{DIGIT}* {
			YYLVAL -> d = atof(yytext);
			return NUM;
		}

{STRING}	{
			strcpy(YYLVAL -> s,yytext + 1);
			YYLVAL -> s[strlen(YYLVAL -> s) - 1] = 0;
			return STRING;
		}

END		return End;
FOR		return For;
NEXT		return Next;
DATA		{
			int prevx;

			prevx = THIS -> m_the_ptr;
			while (C && C != ':')
			{
				YYLVAL -> s[THIS -> m_the_ptr - prevx] = C;
				THIS -> m_the_ptr++;
			}
			YYLVAL -> s[THIS -> m_the_ptr - prevx] = 0;
			return Data;
		}
INPUT		return Input;
DEL		return Del;
DIM		return Dim;
READ		return Read;

GR		return Gr;
TEXT		return Text;
PR		return Pr;
IN		return In;
CALL		return Call;
PLOT		return Plot;
HLIN		return Hlin;
VLIN		return Vlin;

HGR2		return Hgr2;
HGR		return Hgr;
HCOLOR		return Hcolor;
HPLOT		return Hplot;
DRAW		return Draw;
XDRAW		return Xdraw;
HTAB		return Htab;
HOME		return Home;

ROT		return Rot;
SCALE		return Scale;
SHLOAD		return Shload;
TRACE		return Trace;
NOTRACE		return Notrace;
NORMAL		return Normal;
INVERSE		return Inverse;
FLASH		return Flash;

COLOR		return Color;
POP		return Pop;
VTAB		return Vtab;
HIMEM		return Himem;
LOMEM		return Lomem;
ONERR		return Onerr;
RESUME		return Resume;
RECALL		return Recall;

STORE		return Store;
SPEED"="	return Speed;
LET		return Let;
GOTO		return Goto;
RUN		return Run;
IF		return If;
RESTORE		return Restore;

GOSUB		return Gosub;
RETURN		return Return;
REM		{
			strcpy(YYLVAL -> s,THIS -> m_the_str + THIS -> m_the_ptr);
			C = 0;
			return Rem;
		}
STOP		return Stop;
ON		return On;
WAIT		return Wait;
LOAD		return Load;
SAVE		return Save;

DEF		return Def;
POKE		return Poke;
PRINT		return Print;
CONT		return Cont;
LIST		return List;
CLEAR		return Clear;
GET		return Get;
NEW		return New;

TAB		return Tab;
TO		return To;
FN		return Fn;
SPC		return Spc;
THEN		return Then;
AT		return At;
NOT		return Not;
STEP		return Step;

AND		return And;
OR		return Or;

SGN		return Sgn;
INT		return Int;
ABS		return Abs;
USR		return Usr;
FRE		return Fre;
SCRN		return Scrn;

PDL		return Pdl;
POS		return Pos;
SQR		return Sqr;
RND		return Rnd;
LOG		return Log;
EXP		return Exp;
COS		return Cos;
SIN		return Sin;

TAN		return Tan;
ATN		return Atn;
PEEK		return Peek;
LEN		return Len;
STR"$"		return Str;
VAL		return Val;
ASC		return Asc;
CHR"$"		return Chr;

LEFT"$"		return Left;
RIGHT"$"	return Right;
MID"$"		return Mid;


"<"[ ]*"="		return LTEQ;
"="[ ]*"<"		return LTEQ;
"<"[ ]*">"		return NEQ;
"="[ ]*">"		return GTEQ;
">"[ ]*"="		return GTEQ;

","|":"|";"	return *yytext;

"="|"<"|">"|"("|")" {
			return *yytext;
		}
"*"|"/"|"+"|"-" return *yytext;

{ID}"$"		{
			strcpy(YYLVAL -> s,yytext);
			return STRINGVAR;
		}

{ID}"%"		{
			strcpy(YYLVAL -> s,yytext);
			return NUMVAR;
		}

{ID}		{
			strcpy(YYLVAL -> s,yytext);
			return IDENTIFIER;
		}

[ \t\n]

"\""[^\"]*

.		{
			printf("Unrecognized char '%c' (0x%02x)\n",*yytext,*yytext);
			*YYLVAL -> s = *yytext;
			YYLVAL -> s[1] = 0;
			return UNDEF;
		}

%%

int yywrap()
{
	return 1;		// end of file
}

